from django.contrib import admin
from django.urls import path
from . import views

urlpatterns = [
    path('register/', views.register_view, name='register'),
    path('', views.login_view, name='login'),
    path('logout/', views.logout_view, name='logout'),

    path('note_list/', views.note_list, name='note_list'),
    path('add/', views.add_note, name='add_note'),
    path('edit/<slug:slug>/', views.edit_note, name='edit_note'),
    path('delete/<slug:slug>/', views.delete_note, name='delete_note'),
    path('note/<slug:slug>/', views.note_detail, name='note_detail'),
]